/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.handler;

import frc.emul.config.ConfigException;
import frc.emul.config.data.CfgItemCartridge;
import frc.emul.config.data.CfgItemCartridgeComposite;
import frc.emul.config.data.CfgItemCartridgeStandalone;
import frc.emul.config.data.CfgItemGame;
import frc.emul.config.handler.CLHGame;
import frc.emul.config.handler.CLHGameCartridge;
import frc.emul.config.handler.ConfigLoaderHandler;
import frc.util.xml.XMLLoaderHandler;
import org.xml.sax.Attributes;

public class CLHGameRoms
extends ConfigLoaderHandler {
    public CLHGameRoms(CLHGame cLHGame) {
        super(cLHGame);
    }

    public void pushed(Attributes attributes) {
        CfgItemGame cfgItemGame = ((CLHGame)this.getParent()).game;
        String string = attributes.getValue("system");
        cfgItemGame.systemRom = string == null || string.equals("DEFAULT") ? null : this.getConfig().getSystemRom(string);
        if (cfgItemGame.systemRom == null) {
            cfgItemGame.systemRomDefault = true;
            cfgItemGame.systemRom = this.getConfig().getDefaultSystemRom();
        } else {
            cfgItemGame.systemRomDefault = false;
        }
        String string2 = attributes.getValue("cartridge");
        if (CfgItemCartridge.isNotBlank(string2)) {
            this.createStandaloneCartridge().cartridgePath = string2;
        }
    }

    public XMLLoaderHandler getChildHandler(String string, Attributes attributes) {
        if (string.equals("cartridge")) {
            if (this.isCartridgeCreated()) {
                CLHGame cLHGame = (CLHGame)this.getParent();
                throw new ConfigException("Game " + cLHGame.getGameID() + " : " + "roms".toUpperCase() + " tags associated with a '" + "cartridge" + "' attribute cannot contain a <" + "cartridge".toUpperCase() + "> sub tag");
            }
            return new CLHGameCartridge(this);
        }
        return super.getChildHandler(string, attributes);
    }

    CfgItemCartridgeStandalone createStandaloneCartridge() {
        return ((CLHGame)this.getParent()).attachNewStandaloneCartridge();
    }

    CfgItemCartridgeComposite createCompositeCartridge() {
        return ((CLHGame)this.getParent()).attachNewCompositeCartridge();
    }

    private boolean isCartridgeCreated() {
        return ((CLHGame)this.getParent()).isCartridgeCreated();
    }
}

